﻿using System;
using System.Collections.Generic;
using System.Linq;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
    public class REGISTRY_DEMOGRAPHICSDB : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors

        public REGISTRY_DEMOGRAPHICSDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public REGISTRY_DEMOGRAPHICS GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REGISTRY_DEMOGRAPHICS_ID)
        {
            REGISTRY_DEMOGRAPHICS objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REGISTRY_DEMOGRAPHICS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, REGISTRY_DEMOGRAPHICS_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public REGISTRY_DEMOGRAPHICS GetItemByPatientId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
        {
            REGISTRY_DEMOGRAPHICS objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REGISTRY_DEMOGRAPHICS_getByPatientId(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<REGISTRY_DEMOGRAPHICS> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<REGISTRY_DEMOGRAPHICS> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REGISTRY_DEMOGRAPHICS_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, REGISTRY_DEMOGRAPHICS objSave)
        {
            Int32? objReturn = objSave.PATIENT_ID;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                   
                    dbContext.usp_REGISTRY_DEMOGRAPHICS_save(
                        CURRENT_USER, 
                        CURRENT_REGISTRY_ID,
                        objSave.REGISTRY_DEMOGRAPHICS_ID,
                        objSave.PATIENT_ID,
                        objSave.STD_REGISTRY_ID,
                        objSave.ADMIT_DATE_TXT,
                        objSave.SERVICE_CONNECTED_IND,
                        objSave.INPATIENT_IND,
                        objSave.ADDRESS_LINE1,
                        objSave.ADDRESS_LINE2,
                        objSave.ADDRESS_LINE3,
                        objSave.CITY,
                        objSave.POSTAL_CODE,
                        objSave.HOME_PHONE,
                        objSave.CELL_PHONE,
                        objSave.ALT_PHONE,
                        objSave.EMAIL_ADDRESS,
                        objSave.ALT_EMAIL_ADDRESS,
                        objSave.ADDRESS_ERROR_CODE,
                        objSave.CREATEDBY,
                        objSave.CREATED,
                        objSave.UPDATEDBY,
                        objSave.UPDATED,
                        objSave.STD_ADDRESSTYPE_ID,
                        objSave.ZIP_PLUS_4,
                        objSave.WORK_PHONE,
                        objSave.STATE,
                        objSave.COUNTY,
                        objSave.COUNTRY,
                        objSave.PREFERRED_PHONE_TYPE,
                        objSave.NEXT_OF_KIN_RELATIONSHIP,
                        objSave.NEXT_OF_KIN_FNAME,
                        objSave.NEXT_OF_KIN_MNAME,
                        objSave.NEXT_OF_KIN_LNAME,
                        objSave.TEMPORARY_ADDRESS_START_DATE,
                        objSave.TEMPORARY_ADDRESS_END_DATE);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REGISTRY_DEMOGRAPHICS_ID)
        {
            Boolean objReturn = false;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_REGISTRY_DEMOGRAPHICS_delete(CURRENT_USER, CURRENT_REGISTRY_ID, REGISTRY_DEMOGRAPHICS_ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        #endregion
    }
}
